<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Kegiatan extends Model
{
    use HasFactory;

    protected $table = 'tbl_kegiatan';

    protected $fillable = [
        'kode_kegiatan',
        'nama_kegiatan',
        'jenis_kegiatan',
        'uraian_kegiatan',
        'tanggal_mulai',
        'tanggal_selesai',
        'tempat',
        'alamat_tempat',
        'struktur_penyelenggara_id',
        'pic_kegiatan',
        'pic_id',
        'catatan',
        'status_kegiatan'
    ];

    protected $casts = [
        'tanggal_mulai' => 'datetime',
        'tanggal_selesai' => 'datetime'
    ];


    // Accessor untuk badge jenis kegiatan
    public function getJenisBadgeAttribute()
    {
        return match ($this->jenis_kegiatan) {
            'Mabit'      => 'primary',
            'Rapat'      => 'info',
            'Pelatihan'  => 'success',
            'Sosialisasi'=> 'warning',
            'Lainnya'    => 'secondary',
            default      => 'dark',
        };
    }

    // Accessor untuk badge status kegiatan
    public function getStatusBadgeAttribute()
    {
        return match ($this->status_kegiatan) {
            'Direncanakan' => 'secondary',
            'Berlangsung'  => 'primary',
            'Selesai'      => 'success',
            'Dibatalkan'   => 'danger',
            default        => 'dark',
        };
    }


    
    // Relationships
    public function strukturPenyelenggara()
    {
        return $this->belongsTo(StrukturOrganisasi::class, 'struktur_penyelenggara_id');
    }

    public function absensiKegiatan()
    {
        return $this->hasMany(AbsensiKegiatan::class, 'kegiatan_id');
    }

       public function partisipan()
    {
        return $this->hasMany(PartisipanKegiatan::class, 'kegiatan_id');
    }

        public function partisipans()
{
    return $this->hasMany(PartisipanKegiatan::class, 'kegiatan_id');
}

public function getTotalPartisipan()
{
    return $this->partisipans()->count();
}

public function getTotalHadir()
{
    return $this->partisipans()
        ->where('status_kehadiran', 'Hadir')
        ->count();
}

    // Scopes
    public function scopeCompleted($query)
    {
        return $query->where('status_kegiatan', 'Completed');
    }

    public function scopeThisMonth($query)
    {
        return $query->whereMonth('tanggal_mulai', now()->month)
                     ->whereYear('tanggal_mulai', now()->year);
    }

    // Method untuk cek apakah kegiatan bisa diedit
    public function canBeEdited()
    {
        return in_array($this->status_kegiatan, ['Direncanakan', 'Berlangsung']);
    }
}